/*
Net stock change for two condition table carbon pools: down dead wood and litter
from query of FIADB 

Estimates are an informal approximation of change in condition table carbn pools based on values at time1 and time2
The code generates two tables accoding to stand classifications -- by typegroup versus softwood/hardwood/woodland
The resulting .csv table (e.g., condPseudoChange_07Nov2022.csv)
  returned from oracle is the union tables and is exactly as it appears in the model

Column names are explained in the model, but briefly:
- columns 1-4 classify the forest stand
- DDW_TPAPY: down dead wood carbon change, tons C/acre/year
- LITTER_TPAPY: litter carbon change, tons C/acre/year
- the remaining columns are numerator and denominator values
4 01 groups 
 
See the FIADB database documentaion for additional informaion on data and methods  
https://www.fia.fs.usda.gov/library/database-documentation/index.php#FIADB 


05Oct2023, from 09Dec2022 jes 
*/
SELECT 
  num.conusRegion, 
  num.possibleTypes, 
  num.standOrigin, 
  num.ageBin, 
  num.ddw_tonperyear / den.acres ddw_tpapy, 
  num.litter_tonperyear / den.acres litter_tpapy, 
  num.ddw_tonperyear as ddw_tonperyear, 
  num.litter_tonperyear as litter_tonperyear, 
  den.acres as acres 
FROM 
  (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ddw_tonperacre * EXPNS) ddw_tonperyear, 
      sum(litter_tonperacre * EXPNS) litter_tonperyear 
    FROM 
      (
        SELECT 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          refftgrp.meaning as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * (
              COND.CARBON_DOWN_DEAD - PCOND.CARBON_DOWN_DEAD
            )/ (
              (
                TO_DATE(
                  TO_CHAR(plot.measyear, '0000')|| '-' || TO_CHAR(plot.measmon, '00')|| '-' || TO_CHAR(plot.measday, '00'), 
                  'yyyy-mm-dd'
                ) - TO_DATE(
                  TO_CHAR(pplot.measyear, '0000')|| '-' || TO_CHAR(pplot.measmon, '00')|| '-' || TO_CHAR(pplot.measday, '00'), 
                  'yyyy-mm-dd'
                )
              ) / 365.242199
            )* CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ddw_tonperacre, 
          SUM(
            COND.CONDPROP_UNADJ * (
              COND.CARBON_LITTER - PCOND.CARBON_LITTER
            )/ (
              (
                TO_DATE(
                  TO_CHAR(plot.measyear, '0000')|| '-' || TO_CHAR(plot.measmon, '00')|| '-' || TO_CHAR(plot.measday, '00'), 
                  'yyyy-mm-dd'
                ) - TO_DATE(
                  TO_CHAR(pplot.measyear, '0000')|| '-' || TO_CHAR(pplot.measmon, '00')|| '-' || TO_CHAR(pplot.measday, '00'), 
                  'yyyy-mm-dd'
                )
              ) / 365.242199
            )* CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS litter_tonperacre 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          join (
            select 
              unique plt_cn, 
              condid, 
              prev_plt_cn, 
              prevcond, 
              SUBPTYP 
            from 
              FS_FIADB.SUBP_COND_CHNG_MTRX
          ) sccm on (
            sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN
          ) 
          JOIN FS_FIADB.PLOT PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          sccm.CONDID = COND.CONDID 
          AND sccm.PLT_CN = COND.PLT_CN 
          AND PCOND.CONDID = sccm.PREVCOND 
          AND PCOND.PLT_CN = sccm.PREV_PLT_CN 
          and (
            (
              COND.PROP_BASIS != 'MACR' 
              and sccm.SUBPTYP = 1
            ) 
            or (
              COND.PROP_BASIS = 'MACR' 
              and sccm.SUBPTYP = 3
            )
          ) 
          AND PCOND.cond_status_cd = 1 
          AND COND.COND_STATUS_CD = 1 
          AND COND.CONDPROP_UNADJ IS NOT NULL 
		  
		  --AND ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101) )
		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )
		  
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          refft.typgrpcd, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          refftgrp.meaning, 
          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd), 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) num 
  join (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ESTIMATED_VALUE * EXPNS) acres 
    FROM 
      (
        SELECT 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          refftgrp.meaning as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ESTIMATED_VALUE 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          join (
            select 
              unique plt_cn, 
              condid, 
              prev_plt_cn, 
              prevcond, 
              SUBPTYP 
            from 
              FS_FIADB.SUBP_COND_CHNG_MTRX
          ) sccm on (
            sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN
          ) 
          JOIN FS_FIADB.PLOT PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          sccm.CONDID = COND.CONDID 
          AND sccm.PLT_CN = COND.PLT_CN 
          AND PCOND.CONDID = sccm.PREVCOND 
          AND PCOND.PLT_CN = sccm.PREV_PLT_CN 
          and (
            (
              COND.PROP_BASIS != 'MACR' 
              and sccm.SUBPTYP = 1
            ) 
            or (
              COND.PROP_BASIS = 'MACR' 
              and sccm.SUBPTYP = 3
            )
          ) 
          AND PCOND.cond_status_cd = 1 
          AND COND.COND_STATUS_CD = 1 
          AND COND.CONDPROP_UNADJ IS NOT NULL 
		  
		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )
			
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          refft.typgrpcd, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          refftgrp.meaning, 
          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd), 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) den ON num.conusRegion = den.conusRegion 
  AND num.possibleTypes = den.possibleTypes 
  AND num.standOrigin = den.standOrigin 
  AND num.ageBin = den.ageBin 
union 
SELECT 
  num.conusRegion, 
  num.possibleTypes, 
  num.standOrigin, 
  num.ageBin, 
  num.ddw_tonperyear / den.acres ddw_tpapy, 
  num.litter_tonperyear / den.acres litter_tpapy, 
  num.ddw_tonperyear as ddw_tonperyear, 
  num.litter_tonperyear as litter_tonperyear, 
  den.acres as acres 
FROM 
  (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ddw_tonperacre * EXPNS) ddw_tonperyear, 
      sum(litter_tonperacre * EXPNS) litter_tonperyear 
    FROM 
      (
        SELECT 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          case when refft.typgrpcd in (180, 970) then 'predominantly woodland species, type not known' when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)' when refft.typgrpcd < 400 then 'predominantly softwood species, type not known' else 'predominantly hardwood species, type not known' end as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * (
              COND.CARBON_DOWN_DEAD - PCOND.CARBON_DOWN_DEAD
            )/ (
              (
                TO_DATE(
                  TO_CHAR(plot.measyear, '0000')|| '-' || TO_CHAR(plot.measmon, '00')|| '-' || TO_CHAR(plot.measday, '00'), 
                  'yyyy-mm-dd'
                ) - TO_DATE(
                  TO_CHAR(pplot.measyear, '0000')|| '-' || TO_CHAR(pplot.measmon, '00')|| '-' || TO_CHAR(pplot.measday, '00'), 
                  'yyyy-mm-dd'
                )
              ) / 365.242199
            )* CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ddw_tonperacre, 
          SUM(
            COND.CONDPROP_UNADJ * (
              COND.CARBON_LITTER - PCOND.CARBON_LITTER
            )/ (
              (
                TO_DATE(
                  TO_CHAR(plot.measyear, '0000')|| '-' || TO_CHAR(plot.measmon, '00')|| '-' || TO_CHAR(plot.measday, '00'), 
                  'yyyy-mm-dd'
                ) - TO_DATE(
                  TO_CHAR(pplot.measyear, '0000')|| '-' || TO_CHAR(pplot.measmon, '00')|| '-' || TO_CHAR(pplot.measday, '00'), 
                  'yyyy-mm-dd'
                )
              ) / 365.242199
            )* CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS litter_tonperacre 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          join (
            select 
              unique plt_cn, 
              condid, 
              prev_plt_cn, 
              prevcond, 
              SUBPTYP 
            from 
              FS_FIADB.SUBP_COND_CHNG_MTRX
          ) sccm on (
            sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN
          ) 
          JOIN FS_FIADB.PLOT PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          sccm.CONDID = COND.CONDID 
          AND sccm.PLT_CN = COND.PLT_CN 
          AND PCOND.CONDID = sccm.PREVCOND 
          AND PCOND.PLT_CN = sccm.PREV_PLT_CN 
          and (
            (
              COND.PROP_BASIS != 'MACR' 
              and sccm.SUBPTYP = 1
            ) 
            or (
              COND.PROP_BASIS = 'MACR' 
              and sccm.SUBPTYP = 3
            )
          ) 
          AND PCOND.cond_status_cd = 1 
          AND COND.COND_STATUS_CD = 1 
          AND COND.CONDPROP_UNADJ IS NOT NULL 
		  
 		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )
			
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          refft.typgrpcd, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          refftgrp.meaning, 
          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd), 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) num 
  join (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ESTIMATED_VALUE * EXPNS) acres 
    FROM 
      (
        SELECT 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          case when refft.typgrpcd in (180, 970) then 'predominantly woodland species, type not known' when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)' when refft.typgrpcd < 400 then 'predominantly softwood species, type not known' else 'predominantly hardwood species, type not known' end as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ESTIMATED_VALUE 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          join (
            select 
              unique plt_cn, 
              condid, 
              prev_plt_cn, 
              prevcond, 
              SUBPTYP 
            from 
              FS_FIADB.SUBP_COND_CHNG_MTRX
          ) sccm on (
            sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN
          ) 
          JOIN FS_FIADB.PLOT PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          sccm.CONDID = COND.CONDID 
          AND sccm.PLT_CN = COND.PLT_CN 
          AND PCOND.CONDID = sccm.PREVCOND 
          AND PCOND.PLT_CN = sccm.PREV_PLT_CN 
          and (
            (
              COND.PROP_BASIS != 'MACR' 
              and sccm.SUBPTYP = 1
            ) 
            or (
              COND.PROP_BASIS = 'MACR' 
              and sccm.SUBPTYP = 3
            )
          ) 
          AND PCOND.cond_status_cd = 1 
          AND COND.COND_STATUS_CD = 1 
          AND COND.CONDPROP_UNADJ IS NOT NULL 
		  
		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )
			
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          refft.typgrpcd, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          refftgrp.meaning, 
          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd), 
          case when (
            cond.stdage between 0 
            and 20
          ) then '0-20 years' when (
            cond.stdage between 21 
            and 40
          ) then '21-40 years' when (
            cond.stdage between 41 
            and 60
          ) then '41-60 years' when (
            cond.stdage between 61 
            and 80
          ) then '61-80 years' when (
            cond.stdage between 81 
            and 100
          ) then '81-100 years' when (
            cond.stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) den ON num.conusRegion = den.conusRegion 
  AND num.possibleTypes = den.possibleTypes 
  AND num.standOrigin = den.standOrigin 
  AND num.ageBin = den.ageBin 
ORDER BY 
  conusRegion, 
  possibleTypes, 
  standOrigin, 
  ageBin
